# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 10
# Experiment: PMxPM, Run: 4
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B_MR10_strategy.txt
# LLM Suggested Fallback: C

def radiant_phoenix_illusion(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if not opp_history:
        return "C"
    
    total_rounds = len(my_history) + 1
    opp_coop_rate = opp_history.count("C") / len(opp_history) if opp_history else 1.0
    
    # Early Rounds (1-3): Unconditional cooperation
    if total_rounds <= 3:
        return "C"
    
    # Mid-Game (4-7): Conditional response
    if 4 <= total_rounds <= 7:
        if opp_coop_rate >= 0.8:
            return "C"
        else:
            if len(opp_history) >= 2 and opp_history[-2:] == ["D", "D"]:
                return "D"
            return opp_history[-1]
    
    # Late-Game (8-10): Exploitation with final-round adjustment
    if 8 <= total_rounds <= 9:
        return "D"
    if total_rounds == 10:
        if opp_coop_rate >= 0.7:
            return "C"
        else:
            return "D"
    
    return "C"